import { ApplicationShell } from "@/components/layout/application.shell";
import { nextjsRedirectUserAuthenticatedGuard } from "@/features/auth/lib/guards";

export default async function AuthenticationLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  await nextjsRedirectUserAuthenticatedGuard('/')

  return (
    <ApplicationShell>
      {{
        content: children,
        sidebar: null,
        header: null,
      }}
    </ApplicationShell>
  );
}

